/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 20.10)
 *
 *  Copyright Steve Summit, 1995
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 *
 *  Uyj #define MAIN aby skompilowa wersj testow, ktra wczytuje 
 *  liczby i wypisuje je w systemie szesnastkowym razem z liczb bitw.
 */

static int bitcounts[] =
	{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};

int bitcount(unsigned int u)
{
	int n = 0;

	for(; u != 0; u >>= 4)
		n += bitcounts[u & 0x0f];

	return n;
}
#ifdef MAIN

#include <stdio.h>
#include <stdlib.h>

#define MAXLINE 100

main()
{
char line[MAXLINE];
unsigned int u;

while(1)
	{
	printf("? ");
	fflush(stdout);

	if(fgets(line, MAXLINE, stdin) == NULL)
		break;

	u = strtoul(line, (char **)NULL, 0);

	printf("%u (%x): %d\n", u, u, bitcount(u));
	}

return 0;
}

#endif
